$(document).ready(function () {

	getDataForPage('mainPageLoad') ;

	$(document).on("click", "#submit-button", function() {
		$("#__awsFormFileUpload").submit();
	});

	/***To Upload the files to AWS S3 Bucket***/
	$("#__awsFormFileUpload").on('submit',(function(e) {
		e.preventDefault();
		  var currentlySelectedFolder = $(".currentAnchorSelected").closest('li').data('delimeter') ;
		  var formData				  = new FormData(this) ;
		  formData.append('folderName', currentlySelectedFolder);

		  $.ajax({
				 url: base_url + 'upload/upload_file_to_base64_Aws/',
				 type: "POST",
				// data:  new FormData(this),
				 data:  formData,
				 contentType: false,
				 cache: false,
				 processData:false,
				 dataType: 'json',
				 beforeSend : function()
				 {
					$("#__fileuploadloaderCSS").show() ;
					$("#submit-button").prop("disabled", true);
					$("#submit-button").text("Uploading...");
					//$("#submit-button").hide() ;
				 },
				    success: function(data)
				 {

					$("#submit-button").text("Upload");
					if(data.error == 1) {
						//$(".__requiredMessage").text(data.message) ;
						//$("#submit-button").show() ;
						$("#submit-button").prop("disabled", false);
						$("#__fileuploadloaderCSS").hide() ;
						toastr.error("Please select a file to upload","Error",{showDuration:500});
						//alert(data.message);
					} else {
						if (data.message == "") {
							$("#__fileuploadloaderCSS").hide() ;
							toastr.error("Please select a file to upload","Error",{showDuration:500});
						} else {
							$("#__fileuploadloaderCSS").hide() ;
							if (data.folderName == "__mainRootFolder"){
								getDataForPrefixes('getRootDataFiles') ;
							} else {
								getDataForPrefixes(data.folderName) ;
							}
							pond.removeFiles();
							//alert(data.message) ;
							toastr.success("File(s) uploaded successfully","Success",{showDuration:500});

						}
						//$("#submit-button").show() ;
						$("#submit-button").prop("disabled", false);


						//~ $(".__requiredMessage").text(data.message) ;
						//~ $("#__awsFormFileUpload")[0].reset();
						//~ getDataForPage('uploadPageLoad') ;
						//~ $("#node_1_anchor").addClass("currentAnchorSelected") ;
					}
			  },
			 error: function (jqXHR, exception) {
				   // $("#submit-button").show() ;
					$("#submit-button").prop("disabled", false);
					$("#submit-button").text("Upload");
					$("#__fileuploadloaderCSS").hide() ;
					toastr.error("Network error, please try again later.","Error",{showDuration:500});
			 }
		});
	 }));
	 /***To Upload the files to AWS S3 Bucket***/


	 /***To list the data of currently selected folder***/
	 $(document).on("click", ".jstree-anchor", function() {

		//alert('here') ;
		if ( $(this).hasClass("currentAnchorSelected") ) {
			//alert('Do not hit AJAX') ;
		} else {
			$("a.jstree-anchor").removeClass("currentAnchorSelected") ;
			$(this).addClass("currentAnchorSelected") ;
			var prefix = $(this).parent().data('delimeter') ;

			var currentAnchorId = $(this).attr('id') ;

			if ( currentAnchorId == "node_1_anchor") {
				$('#__deleteFolderTop, #__shareFolderTop').attr('disabled','disabled');
				getDataForPrefixes('getRootDataFiles');
			} else {
				$('#__deleteFolderTop, #__shareFolderTop').removeAttr('disabled');
				getDataForPrefixes(prefix) ;
			}
		}

	 });
	 /***To list the data of currently selected folder***/


	 /***To Delete single object***/
	 $(document).on("click", "#__singleDelete", function() {
			var key = $(this).closest('tr').data('uniquekey') ;
			if (key){
				if (confirm('Are You Sure?')){
					deleteSingleObject(key) ;
				}
			} else {
				alert('Object key is required.' ) ;
			}
	 });
	 /***To Delete single object***/


	 /***To Delete Multiple selected objects***/

	 $(document).on("click", "#__deleteMultipleFiles", function() {
		var rowCountChecked = $('input[type=checkbox][name=check]:checked').length;

		if ( rowCountChecked > 0 ) {
			if (confirm('Are You Sure?')){
				$('#__deleteMultipleFiles, #__shareMultipleFiles').attr('disabled','disabled');
				deleteMultipleObjects();
			}
		} else {
			alert("Please select files.") ;
		}

	 });



	 /***To Delete Multiple selected objects***/


	 /***To create a new folder with empty file***/
		 $(document).on("click", "#__addFolderButton", function() {
			$("#__folderContainerInputBox").show() ;
			$("#__createNewFolder").focus() ;
		 });


		 $(document).on("keyup", "#__createNewFolder", function(e) {
			var yourInput = $(this).val();
			re = /[`~#$%^&*()_|+\-=?;:'",<>\{\}\[\]\\\/@! ]/gi;
			var isSplChar = re.test(yourInput);
			if(isSplChar)
			{
			  var no_spl_char = yourInput.replace(/[`~#$%^&*()_|+\-=?;:'",<>\{\}\[\]\\\/@! ]/gi, '');
			  $(this).val(no_spl_char);
			}


			if (e.keyCode === 13) {
				if (yourInput == '' ) {
					toastr.error("Please enter name.","Error",{showDuration:500});
				} else if( yourInput.length < 5 || yourInput.length > 30) {
					toastr.error("Name can't be less then 5 or more then 30 characters.","Error",{showDuration:500});
				} else {

					/***check folde name don't exists***/

					var folderNameExists = false;

					$('ul#__treeStructureData li').each(function (index) {

						var currentFolderName  = $(this).data("delimeter") ;

						if ( currentFolderName == yourInput + "/") {
							folderNameExists = true ;
						}
					});

					if (!folderNameExists) {
						if (confirm('Are You Sure?')){
							createAwsFolderWithEmptyFile(yourInput) ;
						}
					} else {
						toastr.error("Folder name already exists.","Error",{showDuration:500});
					}
					/***check folde name don't exists***/
				}
			}


			if (e.key === "Escape" || e.key == 27) { // escape key maps to keycode `27`
				$("#__folderContainerInputBox").hide() ;
				$(this).val('');
			}

		})
	 /***To create a new folder with empty file***/

	/***On click of folder delete at top***/
	$(document).on("click", "#__deleteFolderTop", function() {
		var currentPrefix = $("a.currentAnchorSelected").closest('li').data('delimeter') ;

		if ( currentPrefix == "__mainRootFolder") {
			alert("Please select a folder to delete.") ;
		} else {

			if (confirm('Are You Sure?')){
				$('#__deleteFolderTop, #__shareFolderTop').attr('disabled','disabled');
				deletSelectedFolder(currentPrefix) ;
			}
			$("#__deleteFolderTop").tooltip('hide');
		}
	});
	/***On click of folder delete at top***/

	/***On click of folder delete at side***/
	$(document).on("click", "#__deleteFolderSide", function() {
		var currentPrefix = $(this).closest('li').data('delimeter') ;

		if ( currentPrefix == "__mainRootFolder") {
			alert("Please select a folder to delete.") ;
		} else {

			if (confirm('Are You Sure?')){
				$('#__deleteFolderTop, #__shareFolderTop').attr('disabled','disabled');
				deletSelectedFolder(currentPrefix) ;
			}
		}
	});
	/***On click of folder delete at side***/


	/***Rename a file***/
	$(document).on("keyup", "#__newFileName", function(e) {
			var yourInput = $(this).val();
			re = /[`~#$%^&*()_|+\-=?;:'",<>\{\}\[\]\\\/@! .]/gi;
			var isSplChar = re.test(yourInput);
			if(isSplChar)
			{
			  var no_spl_char = yourInput.replace(/[`~#$%^&*()_|+\-=?;:'",<>\{\}\[\]\\\/@! .]/gi, '');
			  $(this).val(no_spl_char);
			}
	});


	$(document).on("click", "#__renameObject", function() {
		$('#__renameObjectForm')[0].reset() ;
		var name 	   = $(this).closest("tr").data('name') ;
		var objectKey  = $(this).closest("tr").data('uniquekey') ;
		var folderName = $("a.currentAnchorSelected").closest('li').data('delimeter') ;

		$('#__previousFileName').attr('placeholder','Current file name: ' + name);
		$("#__previousFileNameValue").val(objectKey);
		$("#__folderName").val(folderName);

		$('#addfoldermodal').modal('show');

	});

	$(document).on("click", "#__submitRenameObject", function(e) {

		e.preventDefault() ;
		var newName = $("#__newFileName").val() ;
		if (newName == "") {
		  toastr.error("Please enter name.","Error",{showDuration:500});
		} else if( newName.length < 5 || newName.length > 50) {
			toastr.error("Name can't be less then 5 or more then 50 characters.","Error",{showDuration:500});
		} else {

			$('#addfoldermodal').modal('hide');
			$.ajax({
				  url: base_url + 'upload/renameFileName' ,
				  type: 'post',
				  dataType: 'json',
				  data: $('#__renameObjectForm').serialize() ,
				  beforeSend : function()
				  {
					$("#__rightBoxTable").hide() ;
					$("#__skeltonLoaderLeftSide").show();
				  },
				  success:function(response){
					  $('#__renameObjectForm')[0].reset();
					  if (response.error == 0) {
						  //alert(response.message);
							toastr.success("File Renamed","Success",{showDuration:500})
						  $("input[name='select-all']").prop('checked', false);

						  if (response.folderName == "__mainRootFolder"){
							getDataForPrefixes('getRootDataFiles') ;
						  } else {
							getDataForPrefixes(response.folderName) ;
						  }

						//  $("a.jstree-anchor").removeClass("currentAnchorSelected") ;
						 // $('li[data-delimeter = "'+ response.folderName +'"] a.jstree-anchor').addClass('currentAnchorSelected');
					  } else {
							$("#__rightBoxTable").show() ;
							$("#__skeltonLoaderLeftSide").hide();
							alert(response.message) ;
					  }
				  }, error: function (jqXHR, exception) {
					    $('#__renameObjectForm')[0].reset();
					    $("#__rightBoxTable").show() ;
						$("#__skeltonLoaderLeftSide").hide();
						toastr.error("Network error, please try again later.","Error",{showDuration:500});
				  }
			 });
		}

	});



	/***Rename a file***/



	/***Move a file***/

	$(document).on("click", "#__moveObject", function() {
		var objectKey  		   = $(this).closest("tr").data('uniquekey') ;
		var selectedFolderName = $("a.currentAnchorSelected").closest('li').data('delimeter') ;
		var htmlLi = "" ;
		var liTreeLength = $('ul#__treeStructureData li').length ;

		$("#__moveObjectKeyName").val(objectKey) ;


		//liTreeLength = 0 ;

		if ( liTreeLength > 0 ) {
			$('ul#__treeStructureData li').each(function (index) {

				var currentFolderName  = $(this).data("delimeter") ;

				if ( currentFolderName != selectedFolderName) {
					htmlLi += '<li data-delimeter="'+currentFolderName+'"><span> <i class="ft-folder"></i> '+currentFolderName.replace("/", "")+'</span></li>' ;
				}
			});
		} else {
			htmlLi += '<li data-delimeter="no_folder_found"><i class="ft-folder"></i> <span>No folders found.</span></li>' ;
		}
		$('#__moveObjectButton').attr('disabled','disabled');
		$("#__movedirectorylist").html(htmlLi) ;
		$('#movefilemodal').modal('show');
	});

	$(document).on("click", "ul#__movedirectorylist li", function() {

		if ( $(this).hasClass("moveselecteddirectroy") ) {

		} else {
			$("ul#__movedirectorylist li").removeClass("moveselecteddirectroy") ;
			$(this).addClass("moveselecteddirectroy") ;

			$('#__moveObjectButton').removeAttr('disabled');
		}

	});


	$(document).on("click", "#__moveObjectButton", function() {
		var fromFolderName  = $("a.currentAnchorSelected").closest('li').data('delimeter') ; //tree structure selected folder
		var toFolderName 	= $("ul#__movedirectorylist li.moveselecteddirectroy").data('delimeter') ; // modal selected folder
		var objectKeyName   = $("#__moveObjectKeyName").val() ;
		$('#movefilemodal').modal('hide');
		$.ajax({
				  url: base_url + 'upload/moveFile' ,
				  type: 'post',
				  dataType: 'json',
				  data: {'fromFolderName': fromFolderName, 'toFolderName': toFolderName, 'objectKeyName': objectKeyName},
				  beforeSend : function()
				  {
					$("#__rightBoxTable").hide() ;
					$("#__skeltonLoaderLeftSide").show();
				  },
				  success:function(response){
					  $("#__moveObjectKeyName").val('') ;
					  if (response.error == 0) {
						  //alert(response.message) ;
							toastr.success("File moved to the destination successfully","Success",{showDuration:500})
						  $("input[name='select-all']").prop('checked', false);

						  if (response.folderName == "__mainRootFolder"){
							getDataForPrefixes('getRootDataFiles') ;
						  } else {
							getDataForPrefixes(response.folderName) ;
						  }

						//  $("a.jstree-anchor").removeClass("currentAnchorSelected") ;
						 // $('li[data-delimeter = "'+ response.folderName +'"] a.jstree-anchor').addClass('currentAnchorSelected');
					  } else {
							$("#__rightBoxTable").show() ;
							$("#__skeltonLoaderLeftSide").hide();
							alert(response.message) ;
					  }
				  }, error: function (jqXHR, exception) {
					    $("#__moveObjectKeyName").val('') ;
					    $("#__rightBoxTable").show() ;
						$("#__skeltonLoaderLeftSide").hide();
						toastr.error("Network error, please try again later.","Error",{showDuration:500});
				  }
			 });

	});
	/***Move a file***/
	
	/***Share a folder***/
	
	$(document).on("click", "#__shareFolderTop, .__shareFolderSide", function() {
		var currentPosition = $(this).data("shareposition") ;
		
		if ( currentPosition == "side" ) {
			var selectedFolderDelimeter  = $(this).closest('li').data('delimeter') ;
			var selectedFoldeName  		 = $(this).closest('li').data('name') ;
		} else {
			var selectedFolderDelimeter  = $("a.currentAnchorSelected").closest('li').data('delimeter') ;
			var selectedFoldeName  		 = $("a.currentAnchorSelected").closest('li').data('name') ;
		}
		
		if ( selectedFolderDelimeter != "__mainRootFolder") {
			$.ajax({
			  url: base_url + 'upload/getCostCenterUsers' ,
			  type: 'post',
			  dataType: 'json',
			  data: { 'selectedFolderDelimeter': selectedFolderDelimeter },
			  success:function(response){
				   if (response.error == 0) {
					 //  $(".duallistbox-custom-text").html(response.content) ;
					   $('.duallistbox-custom-text').empty();
					   $(".duallistbox-custom-text").html(response.content) ;
					   $('.duallistbox-custom-text').bootstrapDualListbox('refresh', true);
					   $("#__dynamicFolderName").text(selectedFoldeName);
					   $('#myShareModal').modal('show');
				  } else {
						toastr.warning(response.message,"Notification",{showDuration:500});
				  }
			  }, error: function (jqXHR, exception) {
					toastr.error("Network error, please try again later.","Error",{showDuration:500});
			  }
			});
		} else {
			toastr.error("Please select a folder.","Error",{showDuration:500});
		}
	});
	
	
	$(document).on("click", "#__shareFolderButton", function() {
		alert($("#bootstrap-duallistbox-selected-list_ > option").length);
		$("#bootstrap-duallistbox-selected-list_ > option").each(function() {
			//alert(this.text + ' ' + this.value);
			var costCenter = $(this).data('costcenter');
			var userId     = $(this).data('userid');
			
			
		});
	});
	/***Share a folder***/
}); // end of document ready


 function getDataForPage(pageLoadType) {
	$('#__deleteFolderTop, #__shareFolderTop').attr('disabled','disabled');
	$.ajax({
		  url: base_url + 'upload/listBucketObjectsAjax' ,
		  type: 'post',
		  dataType: 'json',
		   beforeSend : function()
		  {
				if ( pageLoadType == "uploadPageLoad" ) {
					 $("#__rightBox, #__leftBox").hide() ;
					 $("#__hideonUploadFile").hide() ;
				}
				$("#__skeltonLoaderMain").show();
		  },
		  success:function(response){
			   if (response.error == 0) {
				  if (response.rightSideContent != "") {
					$("#__tableBodyData").html(response.rightSideContent) ;
				  } else {
					$("#__tableBodyData").html("<tr><td colspan='4' class='text-center'>No files found</td></tr>");
				  }
				  $("#__treeStructureData").html(response.treeStructureContent) ;
				  $("#__skeltonLoaderMain").hide();
				  $("#__topBox, #__rightBox, #__leftBox").show() ;
			  } else {
					toastr.error(response.message,"Error",{showDuration:500});
					$("#__skeltonLoaderMain").hide();

			  }
		  }, error: function (jqXHR, exception) {
			    toastr.error("Network error, please try again later.","Error",{showDuration:500});
				$("#__skeltonLoaderMain").hide();
		  }
	 });
 }

  // Get files for folders
  function getDataForPrefixes(prefix) {
	$('#__deleteMultipleFiles, #__shareMultipleFiles').attr('disabled','disabled');

	$.ajax({
		  url: base_url + 'upload/listBucketObjectsAjaxPrefixes' ,
		  type: 'post',
		  dataType: 'json',
		  data: { prefix: prefix } ,
		  beforeSend : function()
		  {
			// $("#__tableBodyData").html("<tr><td colspan='4'>Loading...</td></tr>");
			$("#__rightBoxTable").hide() ;
			$("#__skeltonLoaderLeftSide").show();
		  },
		  success:function(response){
			  if (response.error == 0) {
				  if (response.rightSideContent != "") {
					$("#__tableBodyData").html(response.rightSideContent) ;
				  } else {
					$("#__tableBodyData").html("<tr><td colspan='4' class='text-center'>No files found</td></tr>");
				  }
				  $("input[name='select-all']").prop('checked', false);
				   $("#__skeltonLoaderLeftSide").hide();
				   $("#__rightBoxTable").show() ;
			  } else {
					toastr.error(response.message,"Error",{showDuration:500});
			  }
		  }, error: function (jqXHR, exception) {
				toastr.error("Network error, please try again later.","Error",{showDuration:500});
		  }
	 });
 }


function deleteSingleObject(key) {
	var rowCount = $('#__tableBodyData tr').length;
	//alert(rowCount) ;
	//return false;
	var currentlySelectedFolder = $(".currentAnchorSelected").closest('li').data('delimeter') ;
	$.ajax({
		  url: base_url + 'upload/deleteSingleObject' ,
		  type: 'post',
		  dataType: 'json',
		  data: { key: key, 'folderName':  currentlySelectedFolder} ,
		  beforeSend : function()
		  {
			// $("#__tableBodyData").html("<tr><td colspan='4'>Loading...</td></tr>");
			$("#__rightBoxTable").hide() ;
			$("#__skeltonLoaderLeftSide").show();
		  },
		  success:function(response){
			  if (response.error == 0) {
				  toastr.success(response.message,"Success",{showDuration:500});
				  $("input[name='select-all']").prop('checked', false);

				  if (response.folderName == "__mainRootFolder"){
					getDataForPrefixes('getRootDataFiles') ;
				  } else {
					getDataForPrefixes(response.folderName) ;
				  }

				//  $("a.jstree-anchor").removeClass("currentAnchorSelected") ;
				 // $('li[data-delimeter = "'+ response.folderName +'"] a.jstree-anchor').addClass('currentAnchorSelected');

			  } else {
				    toastr.error(response.message,"Error",{showDuration:500});
			  }
		  }, error: function (jqXHR, exception) {
			    toastr.error("Network error, please try again later.","Error",{showDuration:500});
		  }
	 });

}


function deleteMultipleObjects() {

	var objectKeyArray = [] ;
	var currentlySelectedFolder = $(".currentAnchorSelected").closest('li').data('delimeter') ;

	$('input[type=checkbox][name=check]:checked').each(function (index) {
		var objectKey = $(this).closest('tr').data('uniquekey') ;
		objectKeyArray.push(objectKey) ;
	});

	if (objectKeyArray.length > 0) {

			$.ajax({
			  url: base_url + 'upload/deleteMultipleObjects' ,
			  type: 'post',
			  dataType: 'json',
			  data: { key: JSON.stringify(objectKeyArray), 'folderName':  currentlySelectedFolder} ,
			  beforeSend : function()
			  {
				$("#__rightBoxTable").hide() ;
				$("#__skeltonLoaderLeftSide").show();
			  },
			  success:function(response){
				  if (response.error == 0) {
					  toastr.success(response.message,"Success",{showDuration:500});
					  $("input[name='select-all']").prop('checked', false);

					  if (response.folderName == "__mainRootFolder"){
						getDataForPrefixes('getRootDataFiles') ;
					  } else {
						getDataForPrefixes(response.folderName) ;
					  }

					  //$("a.jstree-anchor").removeClass("currentAnchorSelected") ;
					  //$('li[data-delimeter = "'+ response.folderName +'"] a.jstree-anchor').addClass('currentAnchorSelected');

				  } else {
						toastr.error(response.message,"Error",{showDuration:500});
						$('#__deleteMultipleFiles, #__shareMultipleFiles').removeAttr('disabled','disabled');
				  }
			  }, error: function (jqXHR, exception) {
					toastr.error("Network error, please try again later.","Error",{showDuration:500});
					$('#__deleteMultipleFiles, #__shareMultipleFiles').removeAttr('disabled','disabled');
			  }
		 });

	} else {
		$('#__deleteMultipleFiles, #__shareMultipleFiles').removeAttr('disabled','disabled');
		toastr.error("Please select files.","Error",{showDuration:500});
	}

}

function createAwsFolderWithEmptyFile(newfolderName) {

	if (newfolderName) {

			$.ajax({
			  url: base_url + 'upload/createAwsFolderWithEmptyFile' ,
			  type: 'post',
			  dataType: 'json',
			  data: { 'newfolderName': newfolderName } ,
			  beforeSend : function()
			  {
					$("#__rightBox, #__leftBox").hide() ;
					$("#__hideonUploadFile").hide() ;
					$("#__skeltonLoaderMain").show();
			  },
			  success:function(response){
				  if (response.error == 0) {

					  //alert(response.message) ;
						toastr.success("Directory created","Success",{showDuration:500})

					  $("a.jstree-anchor").removeClass("currentAnchorSelected") ;
					  $("ul#__treeStructureData li").removeClass("jstree-last") ;
					   $("input[name='select-all']").prop('checked', false);

					  var htmlNewFolder = '<li class="jstree-node  jstree-leaf jstree-last" data-delimeter="'+response.folderName+'/"><i class="jstree-icon jstree-ocl" role="presentation"></i><a class="jstree-anchor currentAnchorSelected" style="margin-left:5px;" href="javascript:void(0)"><i class="jstree-icon jstree-themeicon feather icon-folder jstree-themeicon-custom" role="presentation"></i>'+response.folderName+'</a><span class="__jstreeicon_social"><a href="javascript:void(0)" id ="__deleteFolderSide"> <i class="fa fa-trash" aria-hidden="true"></i></a><a href="javascript:void(0)" id ="__shareFolderSide"> <i class="fa fa-share-alt" aria-hidden="true"></i></a></span></li>' ;
					   $("ul#__treeStructureData").append(htmlNewFolder) ;
						$("#__skeltonLoaderMain").hide();
						$("#__rightBox, #__leftBox").show() ;
						$("#__folderContainerInputBox").hide() ;
						$("#__createNewFolder").val('');
						getDataForPrefixes(response.folderName) ;
						$('#__deleteMultipleFiles, #__shareMultipleFiles').removeAttr('disabled','disabled');
				  } else {
						toastr.error(response.message,"Error",{showDuration:500});
						$("#__skeltonLoaderMain").hide();
						$("#__rightBox, #__leftBox").show() ;
				  }
			  }, error: function (jqXHR, exception) {
					toastr.error("Network error, please try again later.","Error",{showDuration:500});
					$("#__skeltonLoaderMain").hide();
					$("#__rightBox, #__leftBox").show() ;
			  }
		 });

	} else {
		toastr.error("Please enter name.","Error",{showDuration:500});
	}

}


function deletSelectedFolder(currentPrefix) {

	if (currentPrefix) {

			$.ajax({
			  url: base_url + 'upload/deleteSelectedFolder' ,
			  type: 'post',
			  dataType: 'json',
			  data: { 'folderName': currentPrefix } ,
			  beforeSend : function()
			  {
					$("#__rightBox, #__leftBox").hide() ;
					$("#__hideonUploadFile").hide() ;
					$("#__skeltonLoaderMain").show();
			  },
			  success:function(response){
				  if (response.error == 0) {

					  //alert(response.message) ;
						toastr.success("Directory deleted","Success",{showDuration:500});

					  $("a.jstree-anchor").removeClass("currentAnchorSelected") ;
					  $("input[name='select-all']").prop('checked', false);
					   //add anchor class pending.


						$("#__skeltonLoaderMain").hide();
						//$("#__rightBox, #__leftBox").show() ;

						getDataForPage('mainPageLoad') ;
						$("#node_1_anchor").addClass("currentAnchorSelected") ;
						//$('#__deleteFolderTop, #__shareFolderTop').removeAttr('disabled','disabled');

				  } else {
						toastr.error(response.message,"Error",{showDuration:500});
						$("#__skeltonLoaderMain").hide();
						$("#__rightBox, #__leftBox").show() ;
						$('#__deleteFolderTop, #__shareFolderTop').removeAttr('disabled','disabled');
				  }
			  }, error: function (jqXHR, exception) {
					toastr.error("Network error, please try again later.","Error",{showDuration:500});
					$("#__skeltonLoaderMain").hide();
					$("#__rightBox, #__leftBox").show() ;
					$('#__deleteFolderTop, #__shareFolderTop').removeAttr('disabled','disabled');
			  }
		 });

	} else {
		$('#__deleteFolderTop, #__shareFolderTop').removeAttr('disabled','disabled');
		toastr.error("Please select a folder to delete.","Error",{showDuration:500});
	}

}
